/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.structures;

import java.util.Random;
import net.minecraft.class_1922;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2794;
import net.minecraft.class_2975;
import net.minecraft.class_3341;
import net.minecraft.class_3443;
import net.minecraft.class_5138;
import net.minecraft.class_5281;
import twilightforest.TwilightForestMod;
import twilightforest.block.TFBlocks;
import twilightforest.world.components.structures.TFStructureComponentOld;
import twilightforest.world.registration.features.TFConfiguredFeatures;

public class TFMaze {
    public int width;
    public int depth;
    public int oddBias = 3;
    public int evenBias = 1;
    public int tall = 3;
    public int head = 0;
    public int roots = 0;
    public int worldX;
    public int worldY;
    public int worldZ;
    public int type;
    public class_3443.class_3444 wallBlocks;
    public class_2680 wallBlockState = ((class_2248)TFBlocks.CUT_MAZESTONE.get()).method_9564();
    public class_2680 headBlockState;
    public class_2680 rootBlockState = ((class_2248)TFBlocks.MAZESTONE.get()).method_9564();
    public class_2680 pillarBlockState = null;
    public class_2680 doorBlockState;
    public float doorRarity = 0.0f;
    public class_2680 torchBlockState = class_2246.field_10336.method_9564();
    public float torchRarity = 0.75f;
    protected int rawWidth;
    protected int rawDepth;
    protected int[] storage;
    public static final int OUT_OF_BOUNDS = Integer.MIN_VALUE;
    public static final int OOB = Integer.MIN_VALUE;
    public static final int ROOM = 5;
    public static final int DOOR = 6;
    public Random rand;

    public TFMaze(int cellsWidth, int cellsDepth) {
        this.width = cellsWidth;
        this.depth = cellsDepth;
        this.rawWidth = this.width * 2 + 1;
        this.rawDepth = this.depth * 2 + 1;
        this.storage = new int[this.rawWidth * this.rawDepth];
        this.rand = new Random();
    }

    private int getCell(int x, int z) {
        return this.getRaw(x * 2 + 1, z * 2 + 1);
    }

    private void putCell(int x, int z, int value) {
        this.putRaw(x * 2 + 1, z * 2 + 1, value);
    }

    private boolean cellEquals(int x, int z, int value) {
        return this.getCell(x, z) == value;
    }

    private int getWall(int sx, int sz, int dx, int dz) {
        if (dx == sx + 1 && dz == sz) {
            return this.getRaw(sx * 2 + 2, sz * 2 + 1);
        }
        if (dx == sx - 1 && dz == sz) {
            return this.getRaw(sx * 2, sz * 2 + 1);
        }
        if (dx == sx && dz == sz + 1) {
            return this.getRaw(sx * 2 + 1, sz * 2 + 2);
        }
        if (dx == sx && dz == sz - 1) {
            return this.getRaw(sx * 2 + 1, sz * 2);
        }
        TwilightForestMod.LOGGER.info("Wall check out of bounds; s = {}, {}; d = {}, {}", (Object)sx, (Object)sz, (Object)dx, (Object)dz);
        return Integer.MIN_VALUE;
    }

    public void putWall(int sx, int sz, int dx, int dz, int value) {
        if (dx == sx + 1 && dz == sz) {
            this.putRaw(sx * 2 + 2, sz * 2 + 1, value);
        }
        if (dx == sx - 1 && dz == sz) {
            this.putRaw(sx * 2, sz * 2 + 1, value);
        }
        if (dx == sx && dz == sz + 1) {
            this.putRaw(sx * 2 + 1, sz * 2 + 2, value);
        }
        if (dx == sx && dz == sz - 1) {
            this.putRaw(sx * 2 + 1, sz * 2, value);
        }
    }

    public boolean isWall(int sx, int sz, int dx, int dz) {
        return this.getWall(sx, sz, dx, dz) == 0;
    }

    public void putRaw(int rawx, int rawz, int value) {
        if (rawx >= 0 && rawx < this.rawWidth && rawz >= 0 && rawz < this.rawDepth) {
            this.storage[rawz * this.rawWidth + rawx] = value;
        }
    }

    private int getRaw(int rawx, int rawz) {
        if (rawx < 0 || rawx >= this.rawWidth || rawz < 0 || rawz >= this.rawDepth) {
            return Integer.MIN_VALUE;
        }
        return this.storage[rawz * this.rawWidth + rawx];
    }

    public void setSeed(long newSeed) {
        this.rand.setSeed(newSeed);
    }

    public void copyToStructure(class_5281 world, class_5138 manager, class_2794 generator, int dx, int dy, int dz, TFStructureComponentOld component, class_3341 sbb) {
        int mdx;
        int z;
        int x;
        for (x = 0; x < this.rawWidth; ++x) {
            for (z = 0; z < this.rawDepth; ++z) {
                int odd;
                int y;
                int even;
                int mdz;
                if (this.getRaw(x, z) == 0) {
                    mdx = dx + x / 2 * (this.evenBias + this.oddBias);
                    mdz = dz + z / 2 * (this.evenBias + this.oddBias);
                    if (this.evenBias > 1) {
                        --mdx;
                        --mdz;
                    }
                    if (this.isEven(x) && this.isEven(z)) {
                        if (this.type == 4 && this.shouldTree(x, z)) {
                            this.putCanopyTree(world, generator, mdx, dy, mdz, component, sbb);
                        } else {
                            for (even = 0; even < this.evenBias; ++even) {
                                for (int even2 = 0; even2 < this.evenBias; ++even2) {
                                    for (y = 0; y < this.head; ++y) {
                                        this.putHeadBlock(world, mdx + even, dy + this.tall + y, mdz + even2, component, sbb);
                                    }
                                    for (y = 0; y < this.tall; ++y) {
                                        if (this.shouldPillar(x, z)) {
                                            this.putPillarBlock(world, mdx + even, dy + y, mdz + even2, component, sbb);
                                            continue;
                                        }
                                        this.putWallBlock(world, mdx + even, dy + y, mdz + even2, component, sbb);
                                    }
                                    for (y = 1; y <= this.roots; ++y) {
                                        this.putRootBlock(world, mdx + even, dy - y, mdz + even2, component, sbb);
                                    }
                                }
                            }
                        }
                    }
                    if (this.isEven(x) && !this.isEven(z)) {
                        for (even = 0; even < this.evenBias; ++even) {
                            for (odd = 1; odd <= this.oddBias; ++odd) {
                                this.makeWallThing(world, dy, component, sbb, mdx, mdz, even, odd);
                            }
                        }
                    }
                    if (this.isEven(x) || !this.isEven(z)) continue;
                    for (even = 0; even < this.evenBias; ++even) {
                        for (odd = 1; odd <= this.oddBias; ++odd) {
                            this.makeWallThing(world, dy, component, sbb, mdx, mdz, odd, even);
                        }
                    }
                    continue;
                }
                if (this.getRaw(x, z) != 6) continue;
                mdx = dx + x / 2 * (this.evenBias + this.oddBias);
                mdz = dz + z / 2 * (this.evenBias + this.oddBias);
                if (this.evenBias > 1) {
                    --mdx;
                    --mdz;
                }
                if (this.isEven(x) && !this.isEven(z)) {
                    for (even = 0; even < this.evenBias; ++even) {
                        for (odd = 1; odd <= this.oddBias; ++odd) {
                            for (y = 0; y < this.head; ++y) {
                                this.putHeadBlock(world, mdx + even, dy + this.tall + y, mdz + odd, component, sbb);
                            }
                            for (y = 0; y < this.tall; ++y) {
                                this.putDoorBlock(world, mdx + even, dy + y, mdz + odd, component, sbb);
                            }
                            for (y = 1; y <= this.roots; ++y) {
                                this.putRootBlock(world, mdx + even, dy - y, mdz + odd, component, sbb);
                            }
                        }
                    }
                }
                if (this.isEven(x) || !this.isEven(z)) continue;
                for (even = 0; even < this.evenBias; ++even) {
                    for (odd = 1; odd <= this.oddBias; ++odd) {
                        for (y = 0; y < this.head; ++y) {
                            this.putHeadBlock(world, mdx + odd, dy + this.tall + y, mdz + even, component, sbb);
                        }
                        for (y = 0; y < this.tall; ++y) {
                            this.putDoorBlock(world, mdx + odd, dy + y, mdz + even, component, sbb);
                        }
                        for (y = 1; y <= this.roots; ++y) {
                            this.putRootBlock(world, mdx + odd, dy - y, mdz + even, component, sbb);
                        }
                    }
                }
            }
        }
        for (x = 0; x < this.rawWidth; ++x) {
            for (z = 0; z < this.rawDepth; ++z) {
                if (this.getRaw(x, z) != 0) continue;
                mdx = dx + x / 2 * (this.evenBias + this.oddBias);
                int mdy = dy + 1;
                int mdz = dz + z / 2 * (this.evenBias + this.oddBias);
                if (!this.isEven(x) || !this.isEven(z) || !this.shouldTorch(x, z) || component.method_14929((class_1922)world, mdx, mdy, mdz, sbb).method_26204() != this.wallBlockState.method_26204()) continue;
                component.method_14917(world, this.torchBlockState, mdx, mdy, mdz, sbb);
            }
        }
    }

    private void makeWallThing(class_5281 world, int dy, TFStructureComponentOld component, class_3341 sbb, int mdx, int mdz, int even, int odd) {
        int y;
        for (y = 0; y < this.head; ++y) {
            this.putHeadBlock(world, mdx + even, dy + this.tall + y, mdz + odd, component, sbb);
        }
        for (y = 0; y < this.tall; ++y) {
            this.putWallBlock(world, mdx + even, dy + y, mdz + odd, component, sbb);
        }
        for (y = 1; y <= this.roots; ++y) {
            this.putRootBlock(world, mdx + even, dy - y, mdz + odd, component, sbb);
        }
    }

    private void putPillarBlock(class_5281 world, int x, int y, int z, TFStructureComponentOld component, class_3341 sbb) {
        component.method_14917(world, this.pillarBlockState, x, y, z, sbb);
    }

    private void putWallBlock(class_5281 world, int x, int y, int z) {
        world.method_8652(new class_2338(x, y, z), this.wallBlockState, 2);
    }

    private void putWallBlock(class_5281 world, int x, int y, int z, TFStructureComponentOld component, class_3341 sbb) {
        if (this.wallBlocks != null) {
            this.wallBlocks.method_14948(this.rand, x, y, z, true);
            component.method_14917(world, this.wallBlocks.method_14947(), x, y, z, sbb);
        } else {
            component.method_14917(world, this.wallBlockState, x, y, z, sbb);
        }
    }

    private void putDoorBlock(class_5281 world, int x, int y, int z, TFStructureComponentOld component, class_3341 sbb) {
        component.method_14917(world, this.doorBlockState, x, y, z, sbb);
    }

    private void carveBlock(class_5281 world, int x, int y, int z) {
        world.method_8652(new class_2338(x, y, z), class_2246.field_10124.method_9564(), 2);
    }

    private void putHeadBlock(class_5281 world, int x, int y, int z) {
        world.method_8652(new class_2338(x, y, z), this.headBlockState, 2);
    }

    private void putHeadBlock(class_5281 world, int x, int y, int z, TFStructureComponentOld component, class_3341 sbb) {
        component.method_14917(world, this.headBlockState, x, y, z, sbb);
    }

    private void putRootBlock(class_5281 world, int x, int y, int z) {
        world.method_8652(new class_2338(x, y, z), this.rootBlockState, 2);
    }

    private void putRootBlock(class_5281 world, int x, int y, int z, TFStructureComponentOld component, class_3341 sbb) {
        component.method_14917(world, this.rootBlockState, x, y, z, sbb);
    }

    private void putCanopyTree(class_5281 world, class_2794 generator, int x, int y, int z, TFStructureComponentOld component, class_3341 sbb) {
        class_2338 pos = component.getBlockPosWithOffset(x, y, z);
        if (sbb.method_14662((class_2382)pos)) {
            ((class_2975)TFConfiguredFeatures.CANOPY_TREE.comp_349()).method_12862(world, generator, this.rand, pos);
        }
    }

    private boolean isEven(int n) {
        return n % 2 == 0;
    }

    private void placeTorches(class_5281 world) {
        int torchHeight = 1;
        for (int x = 0; x < this.rawWidth; ++x) {
            for (int z = 0; z < this.rawDepth; ++z) {
                if (this.getRaw(x, z) != 0) continue;
                int mdx = this.worldX + x / 2 * (this.evenBias + this.oddBias);
                int mdy = this.worldY + torchHeight;
                int mdz = this.worldZ + z / 2 * (this.evenBias + this.oddBias);
                class_2338 pos = new class_2338(mdx, mdy, mdz);
                if (!this.isEven(x) || !this.isEven(z) || !this.shouldTorch(x, z) || world.method_8320(pos).method_26204() != this.wallBlockState.method_26204()) continue;
                world.method_8652(pos, this.torchBlockState, 2);
            }
        }
    }

    public boolean shouldTorch(int rx, int rz) {
        if (this.getRaw(rx + 1, rz) == Integer.MIN_VALUE || this.getRaw(rx - 1, rz) == Integer.MIN_VALUE || this.getRaw(rx, rz + 1) == Integer.MIN_VALUE || this.getRaw(rx, rz - 1) == Integer.MIN_VALUE) {
            return false;
        }
        if (this.getRaw(rx + 1, rz) == 0 && this.getRaw(rx - 1, rz) == 0 || this.getRaw(rx, rz + 1) == 0 && this.getRaw(rx, rz - 1) == 0) {
            return false;
        }
        return this.rand.nextFloat() <= this.torchRarity;
    }

    public boolean shouldPillar(int rx, int rz) {
        if (this.pillarBlockState == null) {
            return false;
        }
        if (this.getRaw(rx + 1, rz) == Integer.MIN_VALUE || this.getRaw(rx - 1, rz) == Integer.MIN_VALUE || this.getRaw(rx, rz + 1) == Integer.MIN_VALUE || this.getRaw(rx, rz - 1) == Integer.MIN_VALUE) {
            return false;
        }
        return !(this.getRaw(rx + 1, rz) == 0 && this.getRaw(rx - 1, rz) == 0 || this.getRaw(rx, rz + 1) == 0 && this.getRaw(rx, rz - 1) == 0);
    }

    public boolean shouldTree(int rx, int rz) {
        if (!(rx != 0 && rx != this.rawWidth - 1 || this.getRaw(rx, rz + 1) == 0 && this.getRaw(rx, rz - 1) == 0)) {
            return true;
        }
        if (!(rz != 0 && rz != this.rawDepth - 1 || this.getRaw(rx + 1, rz) == 0 && this.getRaw(rx - 1, rz) == 0)) {
            return true;
        }
        return this.rand.nextInt(50) == 0;
    }

    public void carveRoom1(int cx, int cz) {
        int rx = cx * 2 + 1;
        int rz = cz * 2 + 1;
        for (int i = -2; i <= 2; ++i) {
            for (int j = -2; j <= 2; ++j) {
                this.putRaw(rx + i, rz + j, 5);
            }
        }
        this.putCell(rx, rz + 1, 0);
        this.putCell(rx, rz - 1, 0);
        this.putCell(rx + 1, rz, 0);
        this.putCell(rx - 1, rz, 0);
        if (this.getRaw(rx, rz + 4) != Integer.MIN_VALUE) {
            this.putRaw(rx, rz + 3, 5);
        }
        if (this.getRaw(rx, rz - 4) != Integer.MIN_VALUE) {
            this.putRaw(rx, rz - 3, 5);
        }
        if (this.getRaw(rx + 4, rz) != Integer.MIN_VALUE) {
            this.putRaw(rx + 3, rz, 5);
        }
        if (this.getRaw(rx - 4, rz) != Integer.MIN_VALUE) {
            this.putRaw(rx - 3, rz, 5);
        }
    }

    public void add4Exits() {
        int hx = this.rawWidth / 2 + 1;
        int hz = this.rawDepth / 2 + 1;
        this.putRaw(hx, 0, 5);
        this.putRaw(hx, this.rawDepth - 1, 5);
        this.putRaw(0, hz, 5);
        this.putRaw(this.rawWidth - 1, hz, 5);
    }

    public void generateRecursiveBacktracker(int sx, int sz) {
        this.rbGen(sx, sz);
    }

    public void rbGen(int sx, int sz) {
        this.putCell(sx, sz, 1);
        int unvisited = 0;
        if (this.cellEquals(sx + 1, sz, 0)) {
            ++unvisited;
        }
        if (this.cellEquals(sx - 1, sz, 0)) {
            ++unvisited;
        }
        if (this.cellEquals(sx, sz + 1, 0)) {
            ++unvisited;
        }
        if (this.cellEquals(sx, sz - 1, 0)) {
            ++unvisited;
        }
        if (unvisited == 0) {
            return;
        }
        int rn = this.rand.nextInt(unvisited);
        int dz = 0;
        int dx = 0;
        if (this.cellEquals(sx + 1, sz, 0)) {
            if (rn == 0) {
                dx = sx + 1;
                dz = sz;
            }
            --rn;
        }
        if (this.cellEquals(sx - 1, sz, 0)) {
            if (rn == 0) {
                dx = sx - 1;
                dz = sz;
            }
            --rn;
        }
        if (this.cellEquals(sx, sz + 1, 0)) {
            if (rn == 0) {
                dx = sx;
                dz = sz + 1;
            }
            --rn;
        }
        if (this.cellEquals(sx, sz - 1, 0) && rn == 0) {
            dx = sx;
            dz = sz - 1;
        }
        if (this.rand.nextFloat() <= this.doorRarity) {
            this.putWall(sx, sz, dx, dz, 6);
        } else {
            this.putWall(sx, sz, dx, dz, 2);
        }
        this.rbGen(dx, dz);
        this.rbGen(sx, sz);
        this.rbGen(sx, sz);
    }
}

